import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIFindTModel1 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		TModelList tl = proxy.find_tModel("uddi-org%", null, null, null, 0 );

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		System.out.println(tis.size()+" tmodel(s) found\n");
		Vector tiv = tis.getTModelInfoVector();
		for (int i = 0; i < tiv.size(); i++) {
			TModelInfo ti = (TModelInfo)tiv.elementAt(i);
			System.out.println(ti.getNameString());
			System.out.println(ti.getTModelKey());
			System.out.println("\n");
		}
	}
}